#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//cmyk persp hex gridMod01.fsh   by   HaleyHalcyon  
//https://www.shadertoy.com/view/slVcRK
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// square root of 3 because hexagon stuff
#define SQRT3 (1.7320508)
// two pi for rotation stuff
#define TURN (6.283185307)
// rotation matrix
#define HALFPI (1.57079632679)
#define ROT(theta) mat2(cos(theta+vec4(0,-HALFPI,HALFPI,0)))
// converts rgb hex code to a vec3
#define HEX(x) (vec3((x >> 16) & 255, (x >> 8) & 255, x & 255) / 255.)
// saw wave to triangle wave
#define ZIG(x) 1. - abs(1. - 2. * x)

// calculate the distance from the center of a hexagon
float hex(vec2 uv) {
    const vec2 tileSize = vec2(1.0, SQRT3);
    vec2 tiled = abs(tileSize - mod(
        uv + vec2(0., SQRT3*2./3.), tileSize * 2.
    ));
    float diag = dot(tiled, tileSize / 2.);
    float thres = step(1.0, diag);
    return mix(
        max(tiled.x, diag),
        max(1. - tiled.x, 2. - diag),
    thres);
}

float hexHelper(vec2 uv, float otherOne) {
    const vec2 tileSize = vec2(1.0, SQRT3);
    uv += 
        vec2(0., SQRT3*2./3.)
        + otherOne * vec2(3., SQRT3);
    vec2 tiled = abs(
        tileSize * vec2(3., 1.) - mod(
            uv, tileSize * vec2(6., 2.)
        )
    );
    float diag = dot(tiled, tileSize);
    
    return step(max(tiled.x, diag * 0.5), 1.0);
}

float hex2(vec2 uv) {
    return max(hexHelper(uv, 0.), hexHelper(uv, 1.));
}

// map the range [0, 1) to stripes of colors
float map(float minv, float maxv, float x) {
    if (minv == maxv) {return step(minv, x);}
    return clamp(0., 1., (x - minv) / (maxv - minv));
}

// set to 1 to enable antialiasing
#define ANTIALIAS 1

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    float time = fract(iTime / 30.);
    // Scales coords so that the diagonals are all the same distance from the center
    
    vec2 uv = (2. * fragCoord.xy - iResolution.xy) / length(iResolution.xy);
    // persp
    uv += 0.125 * cos((time + vec2(0.25, 0)) * TURN);
    uv *= ROT(-time * TURN);
    uv /= 1. - 0.5 * uv.y;
    uv.x *= .875;
    uv *= 8.;
    
    float turnMax = 2. * TURN / 3.;
    uv *= ROT(time * turnMax);
    // shift center of grid
    uv += vec2(1, 1./SQRT3);
    
    
    float dist = hex(uv);
    float hexCol1 = hex2(uv);
    float hexCol2 = hex2(uv + vec2(1, SQRT3));
    vec3 baseCol = (
        HEX(0x009BE8) * hexCol1 +
        HEX(0xEB0072) * hexCol2 +
        HEX(0xfff100) * (1. - hexCol1 - hexCol2)
    );
    
    float distTemp = ZIG(fract(
        1.5 * dist * dist +
        -10. * time +
        0.333 * hexCol1 +
        -0.333 * hexCol2
    ));
#if ANTIALIAS == 1
    float aaWidth = fwidth(distTemp) * 0.75;
    float bright = 
        smoothstep(
            -aaWidth, aaWidth, distTemp - 0.5
        ) * smoothstep(
            -fwidth(dist), fwidth(dist), 0.9 - dist
        )
    ;
#else
    float bright = min(
        step(
            0.5, distTemp
        ), step(
            dist, 0.9
        )
    );
#endif
    vec3 col = mix(HEX(0x010a31), baseCol, bright);

    // Output to screen
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

